#include "Enemy.h"
#include "Timer.h"
#include <iostream>	//Remove later!

Enemy::Enemy()
{
}


Enemy::~Enemy()
{
}

void Enemy::update(float dt)
{
	currentAnimation->animate(dt);
	setTextureRect(currentAnimation->getCurrentFrame());

	velocity.y += gravity * dt;	//Increase the velocity by gravity * delta

	move(velocity.x * dt,  velocity.y * dt);	//Move the enemy

	if (getInvincible())	//If the enemy is invincible
	{
		if (Timer::setWaitTime(getInvincibilityTime(), dt))
		{
			setInvincible(false, 0.0);	//Disable their invincibility after the time is up
		}
	}
}

bool Enemy::isDying()
{
	return dying;	//Return whether or not the enemy is playing its death animation
}

void Enemy::setDying(bool die)
{
	dying = die;	//Set the enemy to play its death animation
}

float Enemy::getDeathTime()
{
	return deathTime;	//Return how long the enemy should play its death animation for
}

